/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.ui.launching;

import com.aptana.core.util.StringUtil;
import com.aptana.php.debug.core.util.NameValuePair;
import com.aptana.php.debug.ui.launching.Messages;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org2.eclipse.php.internal.ui.wizard.field.DialogField;
import org2.eclipse.php.internal.ui.wizard.field.IDialogFieldListener;
import org2.eclipse.php.internal.ui.wizard.field.LayoutUtil;
import org2.eclipse.php.internal.ui.wizard.field.StringDialogField;
import org2.eclipse.php.util.StatusInfo;

public class NameValuePairInputDialog
extends StatusDialog {
    private StringDialogField fNameDialogField;
    private StringDialogField fValueDialogField;
    private List<String> fExistingNames;

    public NameValuePairInputDialog(Shell parent, NameValuePair pair, List<NameValuePair> existingEntries) {
        super(parent);
        this.fExistingNames = new ArrayList<String>(existingEntries.size());
        for (NameValuePair curr : existingEntries) {
            if (curr.equals(pair)) continue;
            this.fExistingNames.add(curr.name);
        }
        if (pair == null) {
            this.setTitle(Messages.NameValuePairInputDialog_addTitle);
        } else {
            this.setTitle(Messages.NameValuePairInputDialog_editTitle);
        }
        CompilerTodoTaskInputAdapter adapter = new CompilerTodoTaskInputAdapter();
        this.fNameDialogField = new StringDialogField();
        this.fNameDialogField.setLabelText(Messages.NameValuePairInputDialog_nameLabel);
        this.fNameDialogField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fValueDialogField = new StringDialogField();
        this.fValueDialogField.setLabelText(Messages.NameValuePairInputDialog_valueLabel);
        this.fValueDialogField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fNameDialogField.setText(pair != null ? pair.name : "");
        this.fValueDialogField.setText(pair != null && pair.value != null ? pair.value : "");
    }

    public NameValuePair getResult() {
        NameValuePair pair = new NameValuePair();
        pair.name = this.fNameDialogField.getText();
        pair.value = this.fValueDialogField.getText();
        return pair;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        inner.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).create());
        this.fNameDialogField.doFillIntoGrid(inner, 2);
        this.fValueDialogField.doFillIntoGrid(inner, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameDialogField.getTextControl(null));
        LayoutUtil.setWidthHint((Control)this.fNameDialogField.getTextControl(null), (int)this.convertWidthInCharsToPixels(45));
        this.fNameDialogField.postSetFocusOnDialogField(parent.getDisplay());
        NameValuePairInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doValidation() {
        String encoded;
        StatusInfo status = new StatusInfo();
        String newText = this.fNameDialogField.getText();
        boolean hasErrorOrWarning = false;
        if (StringUtil.isEmpty((String)newText)) {
            status.setError(Messages.NameValuePairInputDialog_enterFiledNameStatus);
        } else if (this.fExistingNames.contains(newText)) {
            status.setWarning(Messages.NameValuePairInputDialog_nameInUseWarning);
            hasErrorOrWarning = true;
        } else {
            try {
                encoded = URLEncoder.encode(newText, "UTF-8");
                if (!newText.equals(encoded)) {
                    status.setWarning(MessageFormat.format(Messages.NameValuePairInputDialog_encodingStatusWarning, newText, encoded));
                    hasErrorOrWarning = true;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        if (hasErrorOrWarning) {
            this.updateStatus((IStatus)status);
            return;
        }
        newText = this.fValueDialogField.getText();
        try {
            encoded = URLEncoder.encode(newText, "UTF-8");
            if (!newText.equals(encoded)) {
                status.setWarning(MessageFormat.format(Messages.NameValuePairInputDialog_decodingStatusWarning, newText, encoded));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        this.updateStatus((IStatus)status);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    private class CompilerTodoTaskInputAdapter
    implements IDialogFieldListener {
        private CompilerTodoTaskInputAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            NameValuePairInputDialog.this.doValidation();
        }
    }
}

